// eslint-disable-next-line no-unused-vars
/* global sc, sca, request */

let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});

let archive = require('../archive');

$$.debug('export documents request', request);

let id,
  filter,
  merged,
  response,
  error = { status: 200, message: 'OK', code: 0 };

if (request.params) {
  if (request.params.id && request.params.id.length === 1) {
    id = request.params.id[0];
    // check for an optional filter specification
    if (request.params.filter && request.params.filter.length > 0) {
      filter = request.params.filter.join(' ');
    }
    try {
      merged = archive.exportDocuments(id, filter);
    } catch (e) {
      error.status = 404;
      error.code = 2;
      error.message = e.message;
    }
  } else {
    error.status = 400;
    error.code = 1;
    error.message = 'invalid insurance record identifier';
  }
} else {
  error.status = 400;
  error.code = 1;
  error.message = 'missing request parameters';
}

if (error.code === 0) {
  response = {
    body: merged.contentStream,
    name: merged.name,
    size: merged.contentSize,
    type: merged.format.mimeType,
  };
} else {
  response = {
    status: error.status,
    body: 'error [{0}]: {1}'.format(error.code, error.message),
  };
  $$.debug('export documents error response', response);
}

response;
